/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.util;

import com.ibm.hwmca.fw.servlet.pmod.util.NoStandardFormatterException;
import com.ibm.hwmca.fw.util.Trace;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class DateFormatter {
    private static final String TRACE_MASKT = "XPMUDAFT";
    private static final String TRACE_MASKF = "XPMUDAFF";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$Calendar;

    private DateFormatter() {
    }

    public static Object convert(Object subject, Class desired) throws NoStandardFormatterException {
        Trace.trace(TRACE_MASKF, "DateFormatter.convert( " + subject + "(class=" + (subject != null ? subject.getClass().toString() : "null") + "), " + desired + " )");
        try {
            if (subject == null || desired == null) {
                return null;
            }
            if (desired == (class$java$lang$String == null ? (class$java$lang$String = DateFormatter.class$("java.lang.String")) : class$java$lang$String)) {
                return DateFormatter.convertToString(subject);
            }
            if (desired == (class$java$util$Date == null ? (class$java$util$Date = DateFormatter.class$("java.util.Date")) : class$java$util$Date)) {
                return DateFormatter.convertToDate(subject);
            }
            if (desired == (class$java$util$Calendar == null ? (class$java$util$Calendar = DateFormatter.class$("java.util.Calendar")) : class$java$util$Calendar)) {
                return DateFormatter.convertToCalendar(subject);
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "DateFormatter caught exception attempting to format inbound object: " + e);
        }
        Trace.trace(TRACE_MASKT, "DateFormatter is unable to apply standard formatter.");
        throw new NoStandardFormatterException("DateFormatter is unable to find appropriate standard conversion.");
    }

    private static Date convertToDate(Object subject) throws NoStandardFormatterException {
        if (subject instanceof Date) {
            return (Date)subject;
        }
        if (subject instanceof String) {
            try {
                return DateFormatter.convertStringToDate((String)subject);
            }
            catch (Exception e) {
                throw new NoStandardFormatterException("DateFormatter is unable to find appropriate standard conversion. - unknown date format");
            }
        }
        if (subject instanceof Calendar) {
            return ((Calendar)subject).getTime();
        }
        Trace.trace(TRACE_MASKT, "DateFormatter.convert() [Date.class] Unable to apply standard formatter.");
        throw new NoStandardFormatterException("DateFormatter is unable to find appropriate standard conversion.");
    }

    private static Calendar convertToCalendar(Object subject) throws NoStandardFormatterException {
        if (subject instanceof Calendar) {
            return (Calendar)subject;
        }
        if (subject instanceof String) {
            Date date = DateFormatter.convertStringToDate((String)subject);
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            return calendar;
        }
        if (subject instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)subject);
            return calendar;
        }
        Trace.trace(TRACE_MASKT, "DateFormatter.convert() [Calendar.class] Unable to apply standard formatter.");
        throw new NoStandardFormatterException("DateFormatter is unable to find appropriate standard conversion.");
    }

    private static String convertToString(Object subject) throws NoStandardFormatterException {
        if (subject instanceof String) {
            return (String)subject;
        }
        if (subject instanceof Date) {
            DateFormat format = DateFormat.getDateInstance(3);
            return format.format((Date)subject);
        }
        if (subject instanceof Calendar) {
            Date time = ((Calendar)subject).getTime();
            DateFormat format = DateFormat.getDateInstance(3);
            return format.format(time);
        }
        Trace.trace(TRACE_MASKT, "DateFormatter.convert() [String.class] Unable to apply standard formatter.");
        throw new NoStandardFormatterException("DateFormatter is unable to find appropriate standard conversion.");
    }

    public static Date convertStringToDate(String subject) throws NoStandardFormatterException {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            return format.parse(subject);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception parsing (" + subject + ") as SimpleDateFormat, trying SHORT");
            try {
                DateFormat format = DateFormat.getDateInstance(3);
                return format.parse(subject);
            }
            catch (Exception e1) {
                Trace.trace(TRACE_MASKF, "Exception parsing (" + subject + ") as SHORT, trying MEDIUM");
                try {
                    DateFormat format = DateFormat.getDateInstance(2);
                    return format.parse(subject);
                }
                catch (Exception e2) {
                    Trace.trace(TRACE_MASKF, "Exception parsing (" + subject + ") as MEDIUM, trying LONG");
                    try {
                        DateFormat format = DateFormat.getDateInstance(1);
                        return format.parse(subject);
                    }
                    catch (Exception e3) {
                        Trace.trace(TRACE_MASKF, "Exception parsing (" + subject + ") as LONG, trying FULL");
                        try {
                            DateFormat format = DateFormat.getDateInstance(0);
                            return format.parse(subject);
                        }
                        catch (Exception e4) {
                            Trace.trace(TRACE_MASKF, "Exception parsing (" + subject + ") as FULL, punting");
                            throw new NoStandardFormatterException("Unable to find appropriate DateFormatter for String: " + subject);
                        }
                    }
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

